<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametriRicerca = $cerca!="" ? array("nome"=>$cerca) : array();
    $parametri = array("tabella"=>"geecEc_righeProdotti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom CMS - componente prodotti dal negozio</title>

    <?php
        include "../include/cssBaseComponenti.php";
    ?>
</head>

<body>
   
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <?php
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==1) {
                                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                            }
                            else if($_GET["status"]==2) {
                                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                            }
                            else if($_GET["status"]==4) {
                                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                            }
                            else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                            }
                            else { //status = 5
                                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                            }
                        }
                    ?>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2"> Elenco visualizzatori prodotti dal negozio</span> 
                            <a href="creaProdottiDalNegozio.php" class="btn btn-sm btn-primary" >
                                Nuovo visualizzatore prodotti<i class="fas fa-plus ml-2"></i>
                            </a>
                        </div>
                        <div class="panel panel-default">
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <div class="table-responsive table-sm">
                                    <?php
                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }

                                        $colonne = array("ID","Nome","Tipo prodotti","Numero prodotti","Mostra prezzo","");
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($articoliDalBlog = $ris->fetch_assoc()) {
                                            $azioni = array("modifica"=>"creaProdottiDalNegozio.php?id={$articoliDalBlog["id"]}","elimina"=>"eliminaOccorrenza({$articoliDalBlog["id"]},'{$articoliDalBlog["nome"]}')");
                                            $tabella->aggiungiNuovaRiga(array($articoliDalBlog["id"],"<a href=\"creaProdottiDalNegozio.php?id={$articoliDalBlog["id"]}\"><b>{$articoliDalBlog["nome"]}</b></a>",$articoliDalBlog["tipoProdotti"],$articoliDalBlog["numeroProdotti"],$articoliDalBlog["mostraPrezzo"]),$azioni);
                                        }

                                        $tabella->stampa("form", 0);
                                        $ricerca->stampaPaginazione(true,"index.php");

                                    ?>
                                </div>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";
        
        include "../include/jsBaseComponenti.php";
    ?>
    <div class="modal fade" id="modalEliminaOccorrenza" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare l'occorrenza?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <img id="immagineOccorrenzaDaEliminare" class="thumb d-none d-lg-block" src="">
                        <div class="align-self-center">
                            <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteDaEliminare"></em></span>
                            <div id="nomeElementoDaEliminare"></div>
                        </div>
                    </div>
                    <p>L'occorrenza di questo componente non sarà più visibile nelle pagine in cui è utilizzata</p>
                    <input type="text" class="d-none" id="elementoDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOrrorrenza()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">

        function eliminaOccorrenza(id,nome) {
            document.getElementById("elementoDaEliminare").value = id;
            document.getElementById("nomeElementoDaEliminare").innerHTML = nome;
            $('#modalEliminaOccorrenza').modal('show');
        }
        
        function eseguiEliminazioneOrrorrenza() {
            var id = $('#elementoDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"controller/controllerComponente.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("form"+id).className = "d-none";
                        $('#modalEliminaOccorrenza').modal('hide');
                    }
                    else {
                        alert(result);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>